<?php $__env->startSection('title', 'Services'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Services</h1>
    <a href="<?php echo e(route('admin.services.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Service
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($services->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Icon</th>
                        <th>Name</th>
                        <th>Slug</th>
                        <th>Description</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($service->icon): ?>
                                <i class="<?php echo e($service->icon); ?>" style="font-size: 2rem;"></i>
                            <?php else: ?>
                                <i class="bi bi-heart-pulse" style="font-size: 2rem;"></i>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($service->name); ?></td>
                        <td><code><?php echo e($service->slug); ?></code></td>
                        <td><?php echo e(Str::limit($service->description, 50)); ?></td>
                        <td><?php echo e($service->sort_order); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($service->is_active ? 'success' : 'secondary'); ?>">
                                <?php echo e($service->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.services.show', $service)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.services.edit', $service)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="<?php echo e(route('admin.services.destroy', $service)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this service?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No services found. <a href="<?php echo e(route('admin.services.create')); ?>">Add your first service</a>.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/services/index.blade.php ENDPATH**/ ?>